package com.izenpe.zain.cliente.cades;

import org.apache.axis.encoding.Base64;

import com.izenpe.zain.client.ZainConfig;
import com.izenpe.zain.cliente.util.Constantes;
import com.izenpe.zain.cliente.util.Propiedades;
import com.izenpe.zain.cliente.util.ZainUtil;
import com.safelayer.trustedx.client.smartwrapper.Constants;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyRequest;
import com.safelayer.trustedx.client.smartwrapper.SmartVerifyResponse;

public class VerificacionFirmaCades_ES_T_Attached {
	// Nombre del fichero cuya firma va a ser verificada.
	private static final String signName = "HelloWorld.txt_Attached.p7s";

	public static void main(String args[]) {
		try {
			// Asignacin de la configuracin de forma programtica
			ZainConfig.setCurrent(Propiedades.ZAIN_CONFIG);

			/*
			 * Se crea la peticin a travs de la URL definida en ZAIN_ENDPOINT.
			 */
			SmartVerifyRequest smartVerifyReq = new SmartVerifyRequest(Propiedades.ZAIN_ENDPOINT);

			// Se establece el perfil CMS/PKCS#7 en la peticin de Verificacin
			// de firma.
			smartVerifyReq.setProfile(Constants.Profile.CMSPKCS7);

			/*
			 * Se establece el idioma de la peticin en espaol. 2
			 * posibilidades: 1. Espaol: 'es' 2. Ingls: 'en'
			 */
			smartVerifyReq.setLanguage("es");

			// Datos a verificar.
			smartVerifyReq.setSignatureBase64(Base64.encode(ZainUtil.readBinaryFile("data/output/" + signName)));
			
			smartVerifyReq.setAddRevocationValues(Constants.AddValues.SIMPLE);
			smartVerifyReq.setAddCertificateValues(Constants.AddValues.SIMPLE);
			smartVerifyReq.setAddTimeStampValues(Constants.AddValues.SIMPLE);
//			smartVerifyReq.setAddSignatureForm(true);
			
			// Envo de la peticin.
			SmartVerifyResponse smartVerifyResp = smartVerifyReq.send();
			
			

			// Se comprueba la validez de la respuesta de Verificacin de firma
			// PKCS#7.
			if (Constantes.RMAJOR_SUCCESS.equals((smartVerifyResp.getResultMajor()))
					&& Constantes.RMINOR_SUCCESS.equals(smartVerifyResp.getResultMinor())) {
				System.out.println("La firma ha sido verificada con xito.");
			} else {
				System.out.println("La firma tiene errores: " + smartVerifyResp.getResultMessage());
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
}